/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFileImp.h,v 1.4 2000/05/13 06:34:20 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFileImp_h	// [
#define Included_CFileImp_h

#include "pgpClassesConfig.h"

#include "CFile.h"
#include "CImp.h"
#include "CString.h"

_PGP_BEGIN

// Class CFileImp

class CFileImp : public CImp
{
	friend class CFile;

protected:
	CFileImp();

	PGPBoolean	IsOpened() const
	{
		return mIsOpened;
	}

	PGPBoolean	IsReadOnly() const
	{
		return (mOpenFlags & CFile::kReadOnlyFlag ? TRUE : FALSE);
	}

	const char *	Path() const
	{
		return mPath;
	}

#if PGP_EXCEPTIONS
	virtual PGPUInt64	GetLength() const = 0;
	virtual PGPUInt64	GetUniqueFileId() const = 0;
#else	// !PGP_EXCEPTIONS
	virtual CComboError	GetLength(PGPUInt64& length) const = 0;
	virtual CComboError	GetUniqueFileId(PGPUInt64& fileId) const = 0;
#endif	// PGP_EXCEPTIONS

	virtual SMART_ERROR	SetIsCompressed(PGPBoolean isCompressed) = 0;
	virtual SMART_ERROR	SetLength(PGPUInt64 length) = 0;

	static PGPBoolean	IsFileInUseByReader(const char *path);
	static PGPBoolean	IsFileInUseByWriter(const char *path);
	static PGPBoolean	IsFileInUse(const char *path);

	virtual void		Flush() = 0;

	virtual SMART_ERROR	Open(const char *path, PGPUInt32 flags) = 0;
	virtual SMART_ERROR	Close() = 0;
	virtual SMART_ERROR	Delete(const char *path) = 0;
	virtual SMART_ERROR	Move(const char *oldPath, const char *newPath) = 0;

	virtual SMART_ERROR	Read(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const = 0;
	virtual SMART_ERROR	Write(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const = 0;

protected:
	PGPBoolean	mIsOpened;

	CString		mPath;
	PGPUInt32	mOpenFlags;
};

_PGP_END

#endif	// ] Included_CFileImp_h
